#include <iostream>
#include <vector>
#include <stack>
#include <algorithm>
#include <cassert>
#include <climits>

using namespace std;

const long long maxi = LLONG_MAX;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<long long> x(n), h(n);
    for (int i = 0; i < n; ++i) cin >> x[i];
    for (int i = 0; i < n; ++i) cin >> h[i];
	sort(x.begin(), x.end());
    vector<long long> res(n, maxi);
    stack<int> s;
    for (int i = 0; i < n; ++i) {
        while (!s.empty() && h[s.top()] < h[i]) s.pop();
        if (!s.empty()) {
            int j = s.top();
            long long d = (x[i] - x[j]) - (h[j] - h[i]);
            res[i] = min(res[i], d);
        }
        s.push(i);
    }
    while (!s.empty()) s.pop();
    for (int i = n - 1; i >= 0; --i) {
        while (!s.empty() && h[s.top()] < h[i]) s.pop();
        if (!s.empty()) {
            int j = s.top();
            long long d = (x[j] - x[i]) - (h[j] - h[i]);
            res[i] = min(res[i], d);
        }
        s.push(i);
    }
    for (int i = 0; i < n; ++i) {
        if (res[i] == maxi) cout << -1 << '\n';
        else cout << res[i] << '\n';
    }

    return 0;
}